﻿var versionHistory = {
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $("#v-versionsTable").a4datatable({                        
            ajaxAction: a4.getSurveyAction("GetSurveyVersions", "Questionnaire"),
            style: "compact",
            displaySearchBox: false,
            columns: [
                { "Name": "Version", "Data": "Version", "Title": resources.Version },
                { "Name": "DeployedBy", "Data": "CreatedBy", "Title": resources.DeployedBy },
                { "Name": "Date", "Data": "PublishedDate", "Title": resources.Date }
            ],
            contextMenuItems: [
                    { "Action": "restore", "Label": resources.Restore },
                    { "Action": "export", "Label": resources.Export }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "restore":
                        versionHistory.restoreSurveyVersion(row.Version);
                        break
                    case "export":
                        window.location.href = a4.getSurveyAction("ExportSurveyVersion", "Questionnaire", { id: row.Version });
                        break;
                }
            }
        });
    },
    restoreSurveyVersion: function (versionNumber) {
        modalDialog.showConfirmDialog(confirmRestoreResources, function () {
            a4.callServerMethod(a4.getSurveyAction("RestoreSurveyVersion", "Questionnaire"), { versionNb: versionNumber },
                function (result) {
                    a4.parent().location.reload(true);
                });
        }, 250, 500, true);
    }
}

$(document).ready(function () {
    versionHistory.initializeDataTable();
});